﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

/// <summary>
/// Summary description for CTeamData
/// </summary>
public class CTeamDataXfer : CData
{
    public CTeamDataXfer(CData data)
        : base(data)
	{
        //constructors are not inherited in c#!
	}
        
    /// <summary>
    /// saves a team to the database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="lTeamID"></param>
    /// <param name="strTeamLabel"></param>
    /// <returns></returns>
    public CStatus SaveTeam(long lXferSystemID, 
                            long lTeamID, 
                            string strTeamLabel)
    {
        CStatus status = new CStatus();
        
        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nTeamID", lTeamID);
        pList.AddInputParameter("pi_vTeamLabel", strTeamLabel);
        
        return base.DBConn.ExecuteOracleSP("PCK_TEAM.SaveTeam",
                                            pList);
    }

    /// <summary>
    /// Gets a dataset of patients matching a team id
    /// </summary>
    /// <param name="ds"></param>
    /// <returns></returns>
    public CStatus GetTeamPatientsDS( long lTeamID,
                                      out DataSet ds)
    {
        //initialize parameters
        ds = null;
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);
        
        pList.AddInputParameter("pi_nTeamID", lTeamID);
        
        //get the dataset
        CDataSet cds = new CDataSet();
        status = cds.GetOracleDataSet(base.DBConn,
                                       "PCK_TEAM.GetPatientTeamRS",
                                       pList,
                                       out ds);
        return status;
    }

    /// <summary>
    /// get a dataset of all teams, used for patient lookups etc...
    /// </summary>
    /// <param name="ds"></param>
    /// <returns></returns>
    public CStatus GetTeamDS(out DataSet ds)
    {
        //initialize parameters
        ds = null;
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        //get the dataset
        CDataSet cds = new CDataSet();
        status = cds.GetOracleDataSet(base.DBConn,
                                       "PCK_TEAM.GetTeamRS",
                                       pList,
                                       out ds);
        return status;
    }

}
